/*
 * Decompiled with CFR 0.152.
 */
package apicore.mu;

import apicore.message.UUID;
import apicore.mu.MultiUserMessage;
import apicore.ptmp.EncodedBuffer;

public class MUNegotiationMessage
extends MultiUserMessage {
    private String username = "Guest";
    private UUID uuid = null;

    public MUNegotiationMessage(String string, UUID uUID) {
        super.setType(PTMP_TYPE_MUNEGOREQ);
        this.uuid = uUID == null ? UUID.makeRandom() : uUID;
        this.username = string;
    }

    public MUNegotiationMessage() {
        super.setType(PTMP_TYPE_MUNEGOREQ);
        this.uuid = this.uuid == null ? UUID.makeRandom() : this.uuid;
    }

    public UUID getUuid() {
        return this.uuid;
    }

    public String getUsername() {
        return this.username;
    }

    public static MUNegotiationMessage getMessage(EncodedBuffer encodedBuffer) {
        MUNegotiationMessage mUNegotiationMessage = new MUNegotiationMessage();
        mUNegotiationMessage.username = encodedBuffer.getString();
        mUNegotiationMessage.uuid = encodedBuffer.getUUID();
        return mUNegotiationMessage;
    }

    public void serialize(EncodedBuffer encodedBuffer) {
        encodedBuffer.putInt(super.getType());
        encodedBuffer.putString(this.username);
        encodedBuffer.putUUID(this.uuid);
    }

    public String toString() {
        String string = new String();
        string = "[MUNegotiationMessage: \n";
        string = string + "   username: " + this.username + "\n";
        string = string + "       uuid: " + this.uuid + "\n";
        string = string + "]";
        return string;
    }

    public void encodeTypeAndPayload(EncodedBuffer encodedBuffer) {
        encodedBuffer.putInt(super.getType());
        encodedBuffer.putString(this.username);
        encodedBuffer.putUUID(this.uuid);
        encodedBuffer.flip();
    }
}

